package com.devstudio.myshop.exception;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;

import javax.servlet.http.HttpServletRequest;

@ControllerAdvice
public class GlobalExceptionHandler {
    
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    
    @ExceptionHandler(Exception.class)
    public String handleException(Exception ex, Model model, HttpServletRequest request) {
        logger.error("Exception occurred: ", ex);
        
        model.addAttribute("errorMessage", "系统出现错误，请稍后重试或联系管理员。");
        model.addAttribute("errorUrl", request.getRequestURI());
        
        return "error";
    }
    
    @ExceptionHandler(NoHandlerFoundException.class)
    public String handleNotFound(NoHandlerFoundException ex, Model model) {
        logger.warn("Page not found: {}", ex.getRequestURL());
        
        model.addAttribute("errorMessage", "您访问的页面不存在");
        model.addAttribute("errorCode", "404");
        
        return "error";
    }
    
    @ExceptionHandler(MaxUploadSizeExceededException.class)
    public String handleMaxSizeException(MaxUploadSizeExceededException ex, Model model) {
        model.addAttribute("errorMessage", "上传文件过大，请选择较小的文件。");
        
        return "error";
    }
}