package com.devstudio.myshop.controller;

import com.devstudio.myshop.model.Service;
import com.devstudio.myshop.model.ProjectCase;
import com.devstudio.myshop.service.DataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Controller
public class ServiceController {
    
    @Autowired
    private DataService dataService;
    
    @GetMapping("/services")
    public String services(Model model) {
        List<Service> services = dataService.getServices();
        model.addAttribute("services", services);
        return "services";
    }
    
    @GetMapping("/services/{id}")
    public String serviceDetail(@PathVariable String id, Model model) {
        Service service = dataService.getServiceById(id);
        if (service == null) {
            return "redirect:/services";
        }
        
        model.addAttribute("service", service);
        
        // Get related project cases
        List<ProjectCase> relatedCases = dataService.getProjectCasesByServiceType(id);
        model.addAttribute("relatedCases", relatedCases);
        
        return "service-detail";
    }
    
    @GetMapping("/web-development")
    public String webDevelopment(Model model) {
        Service webDevService = dataService.getServiceById("web-development");
        if (webDevService != null) {
            model.addAttribute("service", webDevService);
        }
        
        List<ProjectCase> webDevCases = dataService.getProjectCasesByServiceType("web-development");
        model.addAttribute("cases", webDevCases);
        
        return "web-development";
    }
    
    @GetMapping("/miniprogram-development")
    public String miniprogramDevelopment(Model model) {
        Service miniprogramService = dataService.getServiceById("miniprogram-development");
        if (miniprogramService != null) {
            model.addAttribute("service", miniprogramService);
        }
        
        List<ProjectCase> miniprogramCases = dataService.getProjectCasesByServiceType("miniprogram-development");
        model.addAttribute("cases", miniprogramCases);
        
        return "miniprogram-development";
    }
    
    @GetMapping("/course-design")
    public String courseDesign(Model model) {
        Service courseService = dataService.getServiceById("course-design");
        if (courseService != null) {
            model.addAttribute("service", courseService);
        }
        
        List<ProjectCase> courseCases = dataService.getProjectCasesByServiceType("course-design");
        model.addAttribute("cases", courseCases);
        
        return "course-design";
    }
}