package com.devstudio.myshop.controller;

import com.devstudio.myshop.model.Service;
import com.devstudio.myshop.service.DataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

@Controller
public class PricingController {
    
    @Autowired
    private DataService dataService;
    
    @GetMapping("/pricing")
    public String pricing(Model model) {
        List<Service> services = dataService.getServices();
        model.addAttribute("services", services);
        return "pricing";
    }
    
    @GetMapping("/pricing/{serviceId}")
    public String servicePricing(@PathVariable String serviceId, Model model) {
        Service service = dataService.getServiceById(serviceId);
        if (service == null) {
            return "redirect:/pricing";
        }
        
        model.addAttribute("service", service);
        return "service-pricing";
    }
}