package com.devstudio.myshop.controller;

import com.devstudio.myshop.model.ProjectCase;
import com.devstudio.myshop.service.DataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Controller
public class PortfolioController {
    
    @Autowired
    private DataService dataService;
    
    @GetMapping("/portfolio")
    public String portfolio(
            @RequestParam(name = "type", required = false) String serviceType,
            Model model) {
        
        List<ProjectCase> cases;
        if (serviceType != null && !serviceType.isEmpty()) {
            cases = dataService.getProjectCasesByServiceType(serviceType);
            model.addAttribute("selectedType", serviceType);
        } else {
            cases = dataService.getProjectCases();
        }
        
        model.addAttribute("cases", cases);
        
        // Get all service types for filtering
        List<ProjectCase> allCases = dataService.getProjectCases();
        Map<String, Long> serviceTypeCount = allCases.stream()
                .collect(Collectors.groupingBy(
                    ProjectCase::getServiceType, 
                    Collectors.counting()
                ));
        model.addAttribute("serviceTypeCount", serviceTypeCount);
        
        return "portfolio";
    }
    
    @GetMapping("/portfolio/{id}")
    public String caseDetail(@PathVariable String id, Model model) {
        ProjectCase projectCase = dataService.getProjectCaseById(id);
        if (projectCase == null) {
            return "redirect:/portfolio";
        }
        
        model.addAttribute("projectCase", projectCase);
        
        // Get related project cases based on service type
        List<ProjectCase> relatedCases = dataService.getProjectCasesByServiceType(projectCase.getServiceType());
        // Remove current case from related cases
        relatedCases.removeIf(c -> c.getId().equals(id));
        // Limit to 3 related cases
        if (relatedCases.size() > 3) {
            relatedCases = relatedCases.subList(0, 3);
        }
        model.addAttribute("relatedCases", relatedCases);
        
        return "case-detail";
    }
}