package com.devstudio.myshop.controller;

import com.devstudio.myshop.model.Service;
import com.devstudio.myshop.model.Template;
import com.devstudio.myshop.model.ProjectCase;
import com.devstudio.myshop.service.DataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Controller
public class HomeController {
    
    @Autowired
    private DataService dataService;
    
    @GetMapping("/")
    public String home(Model model) {
        // Get popular templates for the homepage
        List<Template> popularTemplates = dataService.getPopularTemplates();
        model.addAttribute("popularTemplates", popularTemplates);
        
        // Get services for the homepage
        List<Service> services = dataService.getServices();
        model.addAttribute("services", services);
        
        // Get featured project cases
        List<ProjectCase> featuredCases = dataService.getFeaturedCases();
        model.addAttribute("featuredCases", featuredCases);
        
        return "index";
    }
    
    @GetMapping("/about")
    public String about(Model model) {
        return "about";
    }

    @GetMapping("/privacy-policy")
    public String privacyPolicy() {
        return "privacy-policy"; // 返回 privacy-policy.html 模板
    }

    @GetMapping("/terms-of-service")
    public String termsOfService() {
        return "terms-of-service"; // 返回 terms-of-service.html 模板
    }

}