package com.devstudio.myshop.controller;

import com.devstudio.myshop.model.ContactForm;
import com.devstudio.myshop.model.Service;
import com.devstudio.myshop.service.ContactService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import javax.validation.Valid;

@Controller
public class ContactController {
    
    @Autowired
    private ContactService contactService;
    
    @GetMapping("/contact")
    public String contact(Model model) {
        if (!model.containsAttribute("contactForm")) {
            model.addAttribute("contactForm", new ContactForm());
        }
        
        // 简化处理，不使用Service对象
        java.util.List<java.util.Map<String, String>> services = new java.util.ArrayList<>();
        java.util.Map<String, String> service1 = new java.util.HashMap<>();
        service1.put("id", "web-development");
        service1.put("name", "网页开发");
        services.add(service1);
        
        java.util.Map<String, String> service2 = new java.util.HashMap<>();
        service2.put("id", "miniprogram-development");
        service2.put("name", "小程序开发");
        services.add(service2);
        
        java.util.Map<String, String> service3 = new java.util.HashMap<>();
        service3.put("id", "course-design");
        service3.put("name", "课程设计");
        services.add(service3);
        
        model.addAttribute("services", services);
        
        return "contact";
    }
    
    @PostMapping("/contact")
    public String submitContactForm(
            @Valid @ModelAttribute("contactForm") ContactForm contactForm,
            BindingResult bindingResult,
            RedirectAttributes redirectAttributes) {
        
        if (bindingResult.hasErrors()) {
            redirectAttributes.addFlashAttribute("org.springframework.validation.BindingResult.contactForm", bindingResult);
            redirectAttributes.addFlashAttribute("contactForm", contactForm);
            return "redirect:/contact";
        }
        
        String result = contactService.saveContactForm(contactForm);
        
        if ("success".equals(result)) {
            redirectAttributes.addFlashAttribute("contactForm", contactForm);
            return "redirect:/contact-success";
        } else {
            redirectAttributes.addFlashAttribute("errorMessage", "提交失败，请稍后重试或直接联系我们。");
            return "redirect:/contact";
        }
    }
    
    @GetMapping("/contact-success")
    public String contactSuccess(Model model) {
        if (!model.containsAttribute("contactForm")) {
            return "redirect:/contact";
        }
        return "contact-success";
    }
}