package com.devstudio.myshop.controller;

import com.devstudio.myshop.model.ContactForm;
import com.devstudio.myshop.service.ContactService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import java.util.List;

@Controller
@RequestMapping("/admin")
public class AdminController {
    
    @Autowired
    private ContactService contactService;
    
    @GetMapping("")
    public String adminDashboard(Model model) {
        List<ContactForm> submissions = contactService.getAllContactSubmissions();
        model.addAttribute("submissions", submissions);
        model.addAttribute("submissionCount", submissions.size());
        return "admin/dashboard";
    }
    
    @GetMapping("/contact-submissions")
    public String contactSubmissions(Model model) {
        List<ContactForm> submissions = contactService.getAllContactSubmissions();
        model.addAttribute("submissions", submissions);
        model.addAttribute("submissionCount", submissions.size());
        return "admin/contact-submissions";
    }
    

}