# 开发服务展示平台

这是一个基于Spring Boot和Thymeleaf的Web应用，用于展示开发服务、模板和案例。

## 功能特点

- **服务展示**: 展示网页开发、小程序开发、课程设计等服务
- **模板预览**: 分类展示各种网站和程序模板，支持预览和详情查看
- **价格方案**: 清晰的价格展示，包含不同档次的套餐
- **案例展示**: 展示完成的项目案例，按类型筛选
- **联系表单**: 支持用户提交咨询和需求
- **响应式设计**: 适配各种设备屏幕

## 技术栈

- **后端**: Spring Boot, Spring Web, Jackson
- **前端**: Thymeleaf, Bootstrap 5, Font Awesome
- **数据存储**: JSON文件
- **构建工具**: Maven

## 项目结构

```
src/main/java/com/devstudio/myshop/
├── config/                  # 配置类
├── controller/               # 控制器
├── exception/               # 异常处理
├── model/                   # 数据模型
├── service/                 # 业务逻辑
└── MyshopApplication.java   # 主应用程序

src/main/resources/
├── data/                    # JSON数据文件
├── static/                  # 静态资源
├── templates/               # Thymeleaf模板
└── application.properties   # 应用配置
```

## 如何运行

### 前提条件

- JDK 11或更高版本
- Maven 3.6或更高版本

### 运行步骤

1. 克隆或下载项目到本地
2. 在项目根目录执行以下命令:

```bash
mvn clean install
mvn spring-boot:run
```

3. 打开浏览器访问: http://localhost:8080

### 使用IDE运行

1. 使用IntelliJ IDEA或Eclipse导入项目
2. 运行`MyshopApplication.java`主类
3. 访问 http://localhost:8080

## 配置说明

### 应用配置 (application.properties)

```properties
# 服务器端口
server.port=8080

# Thymeleaf配置
spring.thymeleaf.cache=false

# 静态资源配置
spring.mvc.static-path-pattern=/static/**
```

### 数据文件

项目使用JSON文件存储数据，位于`src/main/resources/data/`目录:

- `templates.json`: 模板数据
- `template-categories.json`: 模板分类
- `services.json`: 服务数据
- `project-cases.json`: 案例数据

### 联系表单

用户通过联系表单提交的信息会保存在项目根目录下的`contact-submissions`文件夹中。

## 自定义与扩展

### 添加新页面

1. 在`controller`包中创建新的控制器
2. 在`templates`目录中创建对应的HTML模板
3. 遵循现有页面的结构，继承`layout.html`

### 修改数据

编辑`src/main/resources/data/`目录下的JSON文件即可修改页面展示的内容。

### 修改样式

自定义样式位于`src/main/resources/static/css/style.css`，可以在这里添加或修改CSS规则。

## 许可证

本项目仅用于学习和演示目的。

## 联系方式

如有问题，请通过以下方式联系:

- 邮箱: contact@example.com
- 电话: 138-XXXX-XXXX